package gov.va.med.mhv.rxrefill.essapi.service.util;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.util.MHVApiUtility;
import gov.va.med.mhv.rxrefill.dto.PrescriptionDTO;
import gov.va.med.mhv.rxrefill.enums.MailWindowEnumeration;
import gov.va.med.mhv.rxrefill.enums.PrescriptionStatusEnumeration;
import gov.va.med.mhv.rxrefill.essapi.transfer.PrescriptionDetailTO;
import gov.va.med.mhv.rxrefill.essapi.transfer.PrescriptionTO;
import gov.va.med.mhv.rxrefill.util.RxMessagesUtil;

import java.util.Calendar;
import java.util.Date;

import javax.annotation.Resource;

import org.apache.commons.lang.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component 
public class RxAPIServiceHelper {

	@Autowired
	private RxMessagesUtil rxMessagesUtil;	
	
	public RxAPIServiceHelper() {
		
	}

	public PrescriptionTO convertToPrescriptionTO(PrescriptionDTO rx) {
		PrescriptionTO presTO = new PrescriptionTO();
//		if (rx.getDrugName() != null)
//			presTO.setPrescription(rx.getDrugName() + " RX# " + rx.getPrescriptionNumber() );
		if (rx.getDrugName() != null)
			presTO.setPrescriptionName(rx.getDrugName());
		if(rx.getLastFillDate() != null)
			presTO.setRefillDate(MHVApiUtility.convertDateToRFC1123Pattern(rx.getLastFillDate()));
		if(rx.getLastRefillSubmittedDate() != null)
			presTO.setRefillSubmitDate(MHVApiUtility.convertDateToRFC1123Pattern(rx.getLastRefillSubmittedDate()));
		if(rx.getInstitution() != null) {
			presTO.setFacilityName(rx.getInstitution().getName());
			presTO.setStationNumber(rx.getInstitution().getStationNumber());
		}	
		//	presTO.setPrescriptionTracking(rx.get)
		if(rx.getNumberOfRefills() != null)
			presTO.setRefillRemaining(rx.getNumberOfRefills());
		if(rx.getStatus() !=null)
			presTO.setRefillStatus(rx.getStatus());
		presTO.setIsRefillable(checkRefillable(rx));
		presTO.setIsTrackable(checkTrackable(rx));
		presTO.setPrescriptionId(rx.getId());
		presTO.setOrderedDate(MHVApiUtility.convertDateToRFC1123Pattern(rx.getIssueDateTime()));
		if(rx.getQuantity() != null)
			presTO.setQuantity(rx.getQuantity().intValueExact());
		presTO.setPrescriptionNumber(rx.getPrescriptionNumber());
				if(rx.getExpirationCancelDate() != null)
			presTO.setExpirationDate(MHVApiUtility.convertDateToRFC1123Pattern(rx.getExpirationCancelDate()));
		if(rx.getReleaseDateTime() != null)
					presTO.setDispensedDate(MHVApiUtility.convertDateToRFC1123Pattern(rx.getReleaseDateTime()));		
		return presTO;
	}

	public PrescriptionTO convertToHistoricalPrescriptionTO(PrescriptionDTO rx) {
		PrescriptionTO presTO = new PrescriptionTO();
		if (rx.getDrugName() != null)
			presTO.setPrescriptionName(rx.getDrugName() + " RX# " + rx.getPrescriptionNumber() );
		if(rx.getLastFillDate() != null)
			presTO.setRefillDate(MHVApiUtility.convertDateToRFC1123Pattern(rx.getLastFillDate()));
		if(rx.getInstitution() != null)
			presTO.setFacilityName(rx.getInstitution().getName());
		if(rx.getStatus() !=null)
			presTO.setRefillStatus(rx.getStatus());
		presTO.setIsRefillable(checkRefillable(rx));
		presTO.setIsTrackable(checkTrackable(rx));
		presTO.setPrescriptionId(rx.getId());
		return presTO;
	}

	public PrescriptionDetailTO convertToPrescriptionDetailTO(PrescriptionDTO rx) {
		PrescriptionDetailTO presTO = new PrescriptionDetailTO();

		presTO.setPrescriptionNumber(rx.getPrescriptionNumber());
		if (rx.getDrugName() != null)
			presTO.setPrescriptionName(rx.getDrugName());
		if(rx.getLastFillDate() != null)
			presTO.setFillDate(MHVApiUtility.convertDateToMMDDYYYY(rx.getLastFillDate()));
		if(rx.getReleaseDateTime() != null)
			presTO.setDispensedDate(MHVApiUtility.convertDateToMMDDYYYY(rx.getReleaseDateTime()));
		if(rx.getStatus() != null) {
			if (PrescriptionStatusEnumeration.REFILLINPROCESS.equals(rx.getStatus()))
				presTO.setStatus("Refill in Process");
			else 
				presTO.setStatus (rx.getStatus().substring(0,1).toUpperCase()+ rx.getStatus().substring(1) );
		}
		if(rx.getInstitution() != null)
			presTO.setFacility(rx.getInstitution().getName());
		if(rx.getIssueDateTime() != null)
			presTO.setOrderedDate(MHVApiUtility.convertDateToMMDDYYYY(rx.getIssueDateTime()));
		if(rx.getQuantity() != null)
			presTO.setQuantity(rx.getQuantity().toString());
		if(rx.getNumberOfRefills() != null)
			presTO.setRefillsRemaining(rx.getNumberOfRefills().toString());
		if(rx.getExpirationCancelDate() != null)
			presTO.setExpirationDate(MHVApiUtility.convertDateToMMDDYYYY(rx.getExpirationCancelDate()));
		return presTO;
	}	

	public boolean checkRefillable(PrescriptionDTO rx) {
		if (rx.getIsRefillable() != null && rx.getIsRefillable().booleanValue())
			return true;
		else
			return false;
	}

	public boolean checkTrackable(PrescriptionDTO rx) {
		Calendar cal = Calendar.getInstance();
		int noOfDays = (int)rxMessagesUtil.getRxrefillNoOfDaysToShowTrackingDetails();
		cal.add(Calendar.DAY_OF_YEAR , -1*noOfDays);
		Date daysAgo = cal.getTime();
		if( (MailWindowEnumeration.MAIL.getDescription().equalsIgnoreCase(rx.getMailWindow() ) && rx.getReleaseDateTime() != null) && 
				(rx.getReleaseDateTime().after(daysAgo) || rx.getReleaseDateTime().equals(daysAgo))  ){
			return true;
		}else{
			return false;
		}
	}


	public boolean isRxAgreementSigned(UserProfileDTO uf ) {
		return BooleanUtils.isTrue(uf.getRxAgreementSigned());
	}

	
}
